local ui = setupUI([[
Panel
  height: 38
]])

setDefaultTab("HP")
UI.Separator()
-- Domyślne ustawienia
local defaultHpPercent = 90
local defaultManaId = 3157
local defaultManaPercent = 90
local manaItem = nil
local ManaPercentTextEdit = nil  -- Dodaj deklarację zmiennej
local HpPercentTextEdit = nil  -- Dodaj deklarację zmiennej

-- Inicjalizacja wartości, jeśli nie zostały wcześniej ustawione
storage.ManaPercent = storage.ManaPercent or defaultManaPercent

-- Inicjalizacja wartości, jeśli nie zostały wcześniej ustawione
storage.HpPercent = storage.HpPercent or defaultHpPercent

-- Funkcja do ustawiania nowego procentu życia
function setHpPercent(newHpPercent)
    storage.HpPercent = newHpPercent
	if HpPercent then
		HpPercentTextEdit:setText(tostring(newHpPercent))  -- Aktualizacja interfejsu tekstowego
	end
end

-- Skrypt leczenia
macro(200, "HEAL / LECZENIE", function()
    if (hppercent() <= storage.HpPercent) then
        say(storage.HealText)
    end
end)


UI.Label("SPELL NAME / NAZWA CZARU")
addTextEdit("HealText", storage.HealText or "exura", function(widget, text)
    storage.HealText = text
end)

UI.Label("% HP TO USE HEAL:")
HpPercentTextEdit = addTextEdit("HpPercent", tostring(storage.HpPercent), function(widget, text)
    local newHpPercent = tonumber(text)
    if newHpPercent then
        setHpPercent(newHpPercent)
    else
        print("Invalid input for HpPercent.")
    end
end)


UI.Separator()


-- Funkcja do ustawiania nowego procentu many
function setManaPercent(newManaPercent)
    storage.ManaPercent = newManaPercent
	if ManaPercentTextEdit then
		ManaPercentTextEdit:setText(tostring(newManaPercent))  -- Aktualizacja interfejsu tekstowego
	end
end


-- Skrypt potowania many
macro(200, "POTTING",  function()
    storage.ManaID = manaItem:getItemId()  -- Sprawdź, czy manaItem ma aktualne ID
	if (manapercent() <= storage.ManaPercent) then
        usewith(manaItem:getItemId(), player)
    end
end)


UI.Label("CHOOSE MANARUNE:")
widget = UI.createWidget("BotContainer", nil)
manaItem = g_ui.createWidget("BotItem", widget)
manaItem:setItemId(storage.ManaID or defaultManaId)

UI.Label("% MANA TO USE MANARUNE:")

-- Dodaj interfejs tekstowy do ustawiania procentu many
ManaPercentTextEdit = addTextEdit("ManaPercent", tostring(storage.ManaPercent), function(widget, text)
    local newManaPercent = tonumber(text)
    if newManaPercent then
        setManaPercent(newManaPercent)
    else
        print("Invalid input for ManaPercent.")
    end
end)

UI.Separator()